/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.util.Tuple;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugProcessor
extends Processor {
    private static final Logger log = LoggerFactory.getLogger(DebugProcessor.class);
    private final String name;
    private int processCnt;
    private int lastHash;

    public DebugProcessor() {
        this(DebugProcessor.class.getSimpleName());
    }

    public DebugProcessor(String name) {
        this.name = name;
    }

    @Override
    public void setSuccessors(List<Processor> successors) {
        super.setSuccessors(successors);
        this.checkOneSuccessor();
    }

    @Override
    public void onOperationPlanned(Operation op) {
        super.onOperationPlanned(op);
        if (log.isDebugEnabled()) {
            this.log("Planned " + op);
        }
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        if (log.isDebugEnabled()) {
            int hash = ops.hashCode();
            if (hash != this.lastHash) {
                this.log("operations " + ops.size());
            } else {
                this.log("no change in operations");
            }
            this.lastHash = hash;
        }
        ++this.processCnt;
        return Tuple.create(this.getDefaultSuccessor(), ops);
    }

    private void log(String s2) {
        log.debug(String.format("%s(%d): %s", this.name, this.processCnt, s2));
    }
}

